package ga.core.validation;

import java.util.HashMap;

/**
 * The context of the GA. This is a {@link HashMap} used to transport required
 * data to all components of the algorithm.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
@SuppressWarnings("serial")
public class GAContext extends HashMap<String, Object> {
  /**
   * Gets an {@link Integer} from the map. Returns <code>null</code> if the key
   * does not exist.
   * 
   * @param key
   *          Key of the value.
   * @return The value or <code>null</code>.
   * 
   * @see #get(Object)
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public Integer getInt(final String key) {
    final Object o = get(key);
    if (o != null && o instanceof Number) {
      return ((Number) o).intValue();
    }

    return null;
  }

  /**
   * Gets an {@link Integer} from the map. Returns the default value if the key
   * does not exist.
   * 
   * @param key
   *          Key of the value.
   * @param dfault
   *          Default value.
   * @return The value or default value.
   * 
   * @see #getInt(String)
   * @see #get(Object)
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public Integer getInt(final String key, final int dfault) {
    final Integer i = getInt(key);
    if (i == null) {
      return dfault;
    }

    return i;
  }

  @Override
  public Object put(final String key, final Object value) {
    // TODO Auto-generated method stub
    return super.put(key, value);
  }

  /**
   * Gets a {@link Float} from the map. Returns <code>null</code> if the key
   * does not exist.
   * 
   * @param key
   *          Key of the value.
   * @return The value or <code>null</code>.
   * 
   * @see #get(Object)
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public Float getFloat(final String key) {
    final Object o = get(key);
    if (o != null && o instanceof Number) {
      return ((Number) o).floatValue();
    }

    return null;
  }

  /**
   * Gets a {@link Float} from the map. Returns the default value if the key
   * does not exist.
   * 
   * @param key
   *          Key of the value.
   * @param dfault
   *          Default value.
   * @return The value or default value.
   * 
   * @see #getFloat(String)
   * @see #get(Object)
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public Float getFloat(final String key, final float dfault) {
    final Float i = getFloat(key);
    if (i == null) {
      return dfault;
    }

    return i;
  }
}
